; SLIDE SHOW SAMPLE - dan3 FORMAT
; COLECOVISION, 2016
;
; Idea by Paulo Silva, Portugal
; Coded by Daniel Bienvenu, Canada
; dan3 compression by Daniel Bienvenu, Canada
;
; COMPILE WITH TNIASM
; 	> TNIASM filename.asm

fname "sshowpletter.rom"

; CONSTANTS

NMI_FLAG:	equ	$7000

; PROGRAM

	cpu	z80
	
	; COLECO ROM CARTRIDGE $8000-$FFFF
	org	$8000
	
	; COLECO ROM HEADER
	;dw	$AA55 ; NO TITLE SCREEN
	dw	$55AA

	; COLECO BIOS RESERVED RAM ADDRESSES
	dw	0,0,0,0
	
	; POINTER TO ROM CODE ENTRY POINT
	dw	start
	
	; RST ROUTINES
	; RST 08
	ret
	nop
	nop
	; RST 10
	ret
	nop
	nop
	; RST 18
	ret
	nop
	nop
	; RST 20
	ret
	nop
	nop
	; RST 28
	ret
	nop
	nop
	; RST 30
	ret
	nop
	nop
	; RST 38 ; SPINNER
	ret
	nop
	nop	
	
	; JUMP TO NON MASKABLE ROUTINE
	jp	nmi
	
	; COLECO SCREEN DATA : TITLE/AUTHOR/YEAR
	db "SLIDE SHOW SAMPLE PLETTER/PRESENTS/2017"

	; NON MASKABLE INTERUPT
nmi:
	push	af
	ld		a, 1
	ld		(NMI_FLAG),a	; SET NMI FLAG
	call		$1FDC		; in a, ($BF)
	pop		af
	ret

start:
	; INTERUPT MODE = RST $38
	im		1
	; DISABLE INTETUPT
	di
	
	; CLEAR RAM 7000-73B7
	xor		a
	ld		bc, $03B8
	ld		hl, $7000
	ld		de, $7001
	ld		(hl), a
	ldir
	
	; TURN SOUND OFF
	call		$1FD6

	; CLEAR VRAM 0000-3FFF
	ld		de, $4000
	xor		a
	ld		l,a
	ld		h,a
	call		$1f82
	
	; SCREEN OFF, NMI OFF
	ld		bc, $0182		; vdp_out(1,$82)
	call		$1FD9
	; SET GRAPHIC MODE II
	ld		bc, $0002		; vdp_out(0,2) ; MODE 2
	call		$1FD9
	ld		a, 2
	ld		hl, $1800
	call		$1FB8		; vdp_out(2,ADDR($1800)) ; NAME $1800
	ld		bc, $03FF         ; vdp_out(3,$ff) ; PATTERN $0000
	call		$1FD9
	ld		bc, $0403         ; vdp_out(4,$03) ; COLOR $2000
	call		$1FD9
	ld		de, $1800
	call		default_name_table

	; SLiDE SHOW LOOP
slideshow:
	ld		hl, awblp2
	push	hl
	ld		hl, awblp1
	call		slide
	ld		hl, f1spp2
	push	hl
	ld		hl, f1spp1
	call		slide
	ld		hl, h6exp2
	push	hl
	ld		hl, h6exp1
	call		slide
	ld		hl, mgfap2
	push	hl
	ld		hl, mgfap1
	call		slide
	ld		hl, sotbp2
	push	hl
	ld		hl, sotbp1
	call		slide
	; TODO : SLIDE SHOW
	jp slideshow

slide:
	call		nmioff
	ld		de, $0000
	call		pletter
	pop		bc
	pop		hl
	push	bc
	ld		de, $2000
	call		pletter
	call		nmion
	ld		b, 100 ; (approx 2 seconds)
	call		delay
	jp		clear

;	DE = NAME TABLE VRAM ADDRESS
default_name_table:
	call		vdpwrite
	ld		d, 3
default_name_table_1:
	xor		a
default_name_table_2:
	out		($BE), a
	nop
	inc		a
	jp		nz,default_name_table_2
	dec		d
	jp		nz,default_name_table_1
	ret

; VDPWRITE
;	INPUT
;		DE = VRAM ADDRESS
;	DESTROY
;		C
vdpwrite:
	ld		c, $BF
	out		(c), e
	set		6, d
	out		(c), d
	res		6, d
	ret
	
nmioff:
	ld		bc, $01C2
	jp		$1FD9

nmion:
	ld		bc, $01E2
	jp		$1FD9

; DELAY
;	INPUT
;		B = DELAY TIME IN SCREEN REFRESH CYCLES
;	DESTROY
;		A, B
delay:
	xor		a
	ld		(NMI_FLAG),a
delay_loop:
	ld		a,(NMI_FLAG)
	or		a
	jr		z, delay_loop
	djnz		delay

clear:
	xor		a
	ld		hl, $2000 ; COLOR VRAM ADDR
	ld		de, $1800 ; SIZE
	call		$1f82 ; FILL_VRAM
	ld		hl, $0000 ; PATTERN VRAM ADDR
	ld		de, $1800 ; SIZE
	jp		$1f82 ; FILL_VRAM
	
; dan3 - DECOMPRESSION ROUTINE
pletter:
	; Set Write in VRAM at DE
	call		vdpwrite	

	push	ix
	ld	a, (hl)
	inc	hl
	exx
	ld	de, $0000
	push	de
	add	a, a
	inc	a
	rl	e
	add	a, a
	rl	e
	add	a, a
	rl	e
	rl	e
	ld	hl, pletter_modes
	add	hl, de
	ld	e, (hl)
	inc	hl
	ld	d, (hl)
	push	de
	pop	ix
	pop	de
	ld	e, 1
	exx
	
pletter_literal:
	ld		c, $BE
	outi
	inc		de
pletter_loop:
	call	getbit
	jr	nc, pletter_literal
	
	exx
	ld	h,d
	ld	l,e
pletter_getlen:
	call	getbitexx
	jr	nc,	pletter_lenok
pletter_lus:
	call	getbitexx
	adc	hl, hl
	call	getbitexx
	jr	nc,	pletter_lenok
	call	getbitexx
	adc	hl, hl
	jr	c,	pletter_depack_out
	call	getbitexx
	jr	c,	pletter_lus
pletter_lenok:
	inc	hl
	exx
	ld	c, (hl)
	inc	hl
	ld	b, 0
	bit	7, c
	jr	z, pletter_offsok
	jp	(ix)
	
pletter_mode6:
	call	getbitrlb
pletter_mode5:
	call	getbitrlb
pletter_mode4:
	call	getbitrlb
pletter_mode3:
	call	getbitrlb
pletter_mode2:
	call	getbitrlb
	call	getbit
	jr	nc, pletter_offsok
	or	a
	inc	b
	res	7, c
pletter_offsok:
	inc	bc
	push	hl
	exx
	push	hl
	exx
	ld	l, e
	ld	h, d
	sbc	hl, bc
	pop	bc
	set		6,d
	ex	af,af'
		
pletter_copybytes_loop:
	push	bc
	ld		c, $BF
	out		(c), l
	nop
	out		(c), h
	nop ;	inc		hl	; is not necessary because it's taking care of inside cpi opcode
	nop
	nop
	in		a, ($BE)
	nop
	nop
	nop
	out		(c), e
	nop
	out		(c), d
	inc		de
	nop
	nop
	out		($BE), a
	pop		bc
	cpi
	jp	pe, pletter_copybytes_loop
	res		6,d
	ex		af,af'
	pop		hl		; restore source address (compressed data)
	jp		pletter_loop

getbitexx:
	add		a, a
  	ret		nz
	exx
	ld		a, (hl)
	inc		hl
	exx
	rla
	ret

getbitrlb:
	call	getbit
	rl	b
	ret
getbit:
	add		a, a
  	ret		nz
	ld		a, (hl)
	inc		hl
	rla
	ret

; Depacker exit
pletter_depack_out:
    pop ix
    ei
    ret

pletter_modes:
    dw	pletter_offsok
    dw	pletter_mode2
    dw	pletter_mode3
    dw	pletter_mode4
    dw	pletter_mode5
    dw	pletter_mode6

; DATA

awblp1:
	incbin	"awblp1.bin.plet5"
awblp2:
	incbin	"awblp2.bin.plet5"
f1spp1:
	incbin	"f1spp1.bin.plet5"
f1spp2:
	incbin	"f1spp2.bin.plet5"
h6exp1:
	incbin	"h6exp1.bin.plet5"
h6exp2:
	incbin	"h6exp2.bin.plet5"
mgfap1:
	incbin	"mgfap1.bin.plet5"
mgfap2:
	incbin	"mgfap2.bin.plet5"
sotbp1:
	incbin	"sotbp1.bin.plet5"
sotbp2:
	incbin	"sotbp2.bin.plet5"
